clear all;
%LE Noise calculation for Devenport, Staubs and Glegg (2010) 8-in. 0012
rho=1.1;cinf=340;uinf=30;u2=(uinf*0.039)^2;lf=0.082;
c=0.2032;b=1.8542;m=uinf/cinf;beta=sqrt(1-m^2);
f=logspace(1,4.3,100);omega=f*2*pi;k=omega/cinf;
 
x1=0;x2=10;x3=0;
ke=sqrt(pi)/lf*gamma(5/6)/gamma(1/3);

%Compressible response with convection 
rg=sqrt(x1^2+beta^2*(x2^2+x3^2));
k10=k/beta^2*(x1/rg-m);k30=k*x3/rg;
k0=k/beta^2;kappa=sqrt(k0.^2-k30.^2/beta^2);
 
phi22=4/9/pi*u2^2/ke^2*(omega.^2/uinf^2+k30.^2)/ke^2./(1+(omega.^2/uinf^2+k30.^2)/ke^2).^(7/3);
lambda=-2*(1+i)*E2((kappa-m*k0-k10)*c)/pi./sqrt(omega/uinf+kappa*beta^2)./sqrt(kappa-m*k0-k10)/c;
spp=pi*rho^2*uinf*b*c^2*k.^2/8/rg^2*x2^2/rg^2.*phi22.*abs(lambda).^2;
spl3=10*log10(2*omega.*(2^(1/6)-2^(-1/6)).*spp/4e-10);

%High frequency approximation
ok=omega/ke/uinf;the=atan2(x2,beta*x1);
spphf=4/9/pi*rho^2*uinf*u2^2*b*m/pi/ke^2/rg^2/(1+m)*(ok.^2./(1+ok.^2).^(7/3))*cos(the/2)^2;
splhf3=10*log10(2*omega.*(2^(1/6)-2^(-1/6)).*spphf/4e-10);

%Incompressible response without convection
k3=0;r=sqrt(x1^2+x2^2+x3^2);
phi22=4/9/pi*u2^2/ke^2*(omega.^2/uinf^2+k3.^2)/ke^2./(1+(omega.^2/uinf^2+k3.^2)/ke^2).^(7/3);
S=sears(omega*c/2/uinf);
sppi=pi*rho^2*uinf*b*c^2*k.^2/8/r^2*x2^2/r^2.*phi22.*abs(S).^2;
spli3=10*log10(2*omega.*(2^(1/6)-2^(-1/6)).*sppi/4e-10);

%Incompressible response with thickness correction
tmax=c*0.12;
sppit=sppi.*exp(-omega*tmax/uinf); %correction is squared for spp so no factor of 1/2 in exp
split3=10*log10(2*omega.*(2^(1/6)-2^(-1/6)).*sppit/4e-10);

%Incompressible response with 1/2 thickness correction
sppit2=sppi.*exp(-omega*tmax/2/uinf); %correction is squared for spp so no factor of 1/2 in exp
split23=10*log10(2*omega.*(2^(1/6)-2^(-1/6)).*sppit2/4e-10);

figure
fi=find(f<1000);
h=semilogx(f,spli3,'k',f(fi),split3(fi),'k--',f(fi),split23(fi),'k:');hold on
set(h,'linewidth',2,'color',[0.6 0.6 0.6])
fc=find(f>600);
h=semilogx(f,spl3,'k',f(fc),splhf3(fc),'k--');
set(h,'linewidth',1.5,'color',[0 0 0])

xlabel('f(Hz)');ylabel('SPL 1/3 re 20\muPa');set(gca,'position',[0.1300    0.1100    0.7750    0.7650]);set(gcf,'Position',[50,250,553,648]);

%Add experimental data
dBc=20*log10(1.8/10);
load('DevenportEtAl2010ExpFig6Data.mat');
smbls={'ko','ks','k^','kd'};
legs={'Sears','Sears, thick corr.','Sears, half thick corr.', 'Compressible','High-frequency approx.','Experiment 0 deg.','Experiment 4 deg.','Experiment 8 deg.','Experiment 12 deg.',};
for n=1:4
    a=find(fExp{n}>30);
    h=semilogx(fExp{n}(a),spl3Exp{n}(a)+dBc,'ko');
    set(h,'MarkerFaceColor',[0.333 0.333 0.333]*(n-1));
end
legend(legs,'location','southwest');
flo=25;fhi=15000;
xlim([flo fhi]);ylim([30 60]);set(gca,'box','off');ax1=gca; 
ax2=axes('Position',get(gca,'position'),'XAxisLocation','top','YAxisLocation','right','Color','none');
set(ax2,'ytick',[],'xscale','log');
xlim(ax2,[flo fhi]*2*pi*c/2/uinf);
xlabel(ax2,'\sigma');
siglim=pi/4/beta^2/m
set(ax1,'fontsize',12);set(ax2,'fontsize',12);

function res=sears(sigma)
    res=2/pi./sigma./(besselh(0,sigma)+i*besselh(1,sigma));
end

function res=E2(x)
res=fresnelc(sqrt(2*x/pi))+i*fresnels(sqrt(2*x/pi));
end